library(scales)
library(lme4)

figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/CSV/'

setwd(csvDirectory)
d = read.csv("Cockles Hellegat Development.csv")
d$Date = as.POSIXct(d$Date)
d$Location = factor(d$Location, levels = c('Mudflat','Protected mudflat','Saltmarsh'))
levels(d$Location) = c('Mudflat','Protected mudflat','Saltmarsh')

# ---- 
# In-text statistical information
# Total marked cockle shells used in the experiment:
print(sum(d$Survival[d$Day == 1]))
# -----

d$Survival = d$Survival/20

survival = as.numeric(tapply(d$Survival, list(d$Location, d$Day), mean))
day = rep(sort(unique(d$Day)), each = 3)
location = rep(1:3, times = length(unique(d$Day)))
col = alpha(colorRampPalette(c('black','grey'))(3), 0.8)
pch = 21:23

tiff('Figure 3c.tiff', width = 20, height = 20, units = "cm", res = 300)
par(mar = c(5,5,4,4))
plot(survival ~ day, cex = 1.5, 
     xlim = c(0,80), ylim = c(0,1),
     pch = pch[location], log = '',
     bg = col[location], bty = 'n',
     ylab = 'Marked cockle shells remaining (proportion)',
     xlab = 'Days since installation', cex.lab = 1.4, cex.axis = 1.4)
points(d$Survival ~ d$Day, 
       pch = '.', cex = 5,
       col = col[d$Location])

y = d$Survival
x = d$Day
z = d$Location

m1 = lm(log(y[y != 0]) ~ x[y != 0] * z[y != 0])
m2 = lm(log(y[y != 0]) ~ x[y != 0] * z[y != 0] - z[y != 0])
m3 = lm(log(y[y != 0]) ~ x[y != 0] * z[y != 0] - z[y != 0] + 0)
AIC(m1,m2,m3)
summary(m1)
summary(m2)
summary(m3)
a = summary(m2)$coefficients[1]
b = summary(m2)$coefficients[2]
c1 = summary(m2)$coefficients[3]
c2 = summary(m2)$coefficients[4]
xv = seq(min(d$Day), max(d$Day), length.out = 1000)
yv0 = exp(a + b*xv)
yv1 = exp(a + (b + c1)*xv)
yv2 = exp(a + (b + c2)*xv)
lines(yv0 ~ xv, lwd = 2, col = col[1])
lines(yv1 ~ xv, lwd = 2, col = col[2])
lines(yv2 ~ xv, lwd = 2, col = col[3])

points(c(0.95,0.90,0.85) ~ c(53,53,53), pch = c(23,22,21), bg = rev(col), cex = 2)
legend(y = 1, x = 50, bty = 'n', legend = c('Saltmarsh','Protected mudflat','Mudflat'), cex = 1.4)

setwd(figureDirectory)
dev.off()

# ---------------------
# Mixed model for Rev #2

d = d[d$Date == max(d$Date),]
n = 20
d$Survival = d$Survival*n

Survival = c()
Location = c()
Plot.ID = c()
for(i_plot in 1:dim(d)[1]){
        survival = c(rep(0, times = n - d$Survival[i_plot]),rep(1, times = d$Survival[i_plot]))
        location = rep(d$Location[i_plot], times = n)
        plot.ID = rep(d$Plot.ID[i_plot], times = n)
        
        Survival = c(Survival, survival)
        Location = c(Location, location)
        Plot.ID = c(Plot.ID,plot.ID)
}

d2 = data.frame(Survival, Location, Plot.ID)

m2 = glmer(Survival ~ Location + (1|Plot.ID),binomial, data = d2)
summary(m2)
#(beta = 2.0, SE = 0.4, z(200) = 5.0, p < 0.0001)

